#include <iostream>
#include <algorithm>
using namespace std;

class Tournament {
 public:
  Tournament() {
    for (int i = 0; i < off; ++i)
      data[i + off] = {0, i};
    data[off].second = 1;
    for (int i = off - 1; i > 0; --i)
      data[i] = data[2 * i];
  }

  void Update(int lo, int hi, int add) {
    from = lo;
    to = hi;
    val = add;
    UpdateInternal(1, 0, off);
  }

  int Query() {
    return data[1].second;
  }

 private:
  void Propagate(int node) {
    if (node < off) {
      flag[2 * node] += flag[node];
      flag[2 * node + 1] += flag[node];
    }
    data[node].first += flag[node];
    flag[node] = 0;
  }
  
  pair<int, int> Merge(pair<int, int> a, pair<int, int> b) {
    if (a.first > b.first) return b;
    return a;
  }

  void UpdateInternal(int node, int lo, int hi) {
    Propagate(node);
    if (lo >= to || hi <= from) return;
    if (lo >= from && hi <= to) {
      flag[node] += val;
      Propagate(node);
      return;
    }
    int mid = (lo + hi) / 2;
    UpdateInternal(2 * node, lo, mid);
    UpdateInternal(2 * node + 1, mid, hi);
    data[node] = Merge(data[2 * node], data[2 * node + 1]);
  }

  static const int off = 1 << 17;
  pair<int, int> data[2 * off];
  int flag[2 * off];
  int from, to, val;
} T;

const int MAXN = 100100;
const int MAXL = 100010;

int n;
int a[MAXN];

int main(void) {
  cin >> n;
  for (int i = 0; i < n; ++i) {
    cin >> a[i];
    if (a[i] != -1)
      T.Update(a[i] + 1, MAXL, 1);
  }
  
  for (int i = n - 1; i >= 0; --i) {
    if (a[i] == -1) {
      a[i] = T.Query();
    } else {
      T.Update(a[i] + 1, MAXL, -1);
      T.Update(a[i], MAXL, -1);
    }
  }

  for (int i = 0; i < n; ++i)
    cout << a[i] << " \n"[i + 1 == n];

  return 0;
}

